-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" );


local yes="yes" ;
local yesname="yes" ;
local no="no" ;	
local noname="no" ;	
local name="yesnobox";
	
if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end
if (gDialogTable.yesname) then
	yesname = gDialogTable.yesname;
end
if (gDialogTable.noname) then
	noname = gDialogTable.noname;
end

if (gDialogTable.name) then
	name = gDialogTable.name;
end

kButtonY = kMax-205;
kSpaceX = 37;

MakeDialog
{
	name=name, -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="images/ui/common/popup03",
		x=kCenter,
		y=kCenter,


        Text
		{
			name = "yesnotitle",
			label= gDialogTable.title,
			font = PopupCopyright,
			flags = kVAlignCenter + kHAlignCenter,
			x=0,y=140,w=kMax,h=30
		};
		
		SetStyle(DialogBodyText),
		Text
		{
			name = "yesnobody",
			label= gDialogTable.body,
		};

        SetStyle(FitnessButtonStyleTittleSmallBlue),
        
        SBButton
        {
			x = kCenter-kSpaceX,
            y = kButtonY,
            label = "ui.label.blank",
            icon="assets/images/ui/buttons/icon/iconok",
			command=
				function()
					if (gDialogTable.yes) then 
						gDialogTable.yes() ; 
					end
				end;
            close = true,
            flags = 5,
            name = yesname,
          
        },
        
        Text
		{
			font = SmallFont,
			name = "txchangeplayer",
			x = kCenter-kSpaceX,
            y = kButtonY+30,
			flags = kHAlignCenter + kVAlignCenter,
			w=100,
			label		= yes,
		};
        SBButton
        {
			command=
				function() 
					if (gDialogTable.no) then
						gDialogTable.no() ; 
					end
                end;
            close = true,
            icon="assets/images/ui/buttons/icon/iconcancel",
            flags = 5,
            label = "ui.label.blank",
            name = noname,
            x = kCenter+kSpaceX,
            y = kButtonY,
        },
        
        
        Text
		{
			font = SmallFont,
			name = "txchangeplayer",
			x = kCenter+kSpaceX,
            y = kButtonY+30,
			flags = kHAlignCenter + kVAlignCenter,
			w=100,
			label= no,
		};
        
    },

} -- MakeDialog
